
let config_ml = "lib/xcp_inventory_config.ml"

(* Configure script *)
open Cmdliner

let default_inventory =
  let doc = "Set the default filename for the inventory" in
  Arg.(value & opt string "/etc/xcp/inventory" & info ["default_inventory"] ~docv:"DEFAULT_INVENTORY" ~doc)

let info =
  let doc = "Configures a package" in
  Term.info "configure" ~version:"0.1" ~doc 

let output_file filename lines =
  let oc = open_out filename in
  let lines = List.map (fun line -> line ^ "\n") lines in
  List.iter (output_string oc) lines;
  close_out oc

let configure inventory =
  Printf.printf "Configuring with default_inventory=%s\n" inventory;

  (* Write config.ml *)
  let lines = 
    [ "(* Warning - this file is autogenerated by the configure script *)";
      "(* Do not edit *)";
      Printf.sprintf "let default_inventory=\"%s\"" inventory;
    ] in
  output_file config_ml lines

let configure_t = Term.(pure configure $ default_inventory)

let () = 
  match 
    Term.eval (configure_t, info) 
  with
  | `Error _ -> exit 1 
  | _ -> exit 0
