Xmlm — Streaming XML codec for OCaml
-------------------------------------------------------------------------------
Release %%VERSION%%

Xmlm is a streaming codec to decode and encode the XML data format. It
can process XML documents without a complete in-memory representation of the
data.

Xmlm is made of a single independent module and distributed
under the BSD3 license.

Home page: http://erratique.ch/software/xmlm  
Contact: Daniel Bünzli `<daniel.buenzl i@erratique.ch>`


## Installation

Xmlm can be installed with `opam`:

    opam install xmlm

If you don't use `opam` consult the [`opam`](opam) file for build
instructions.

## Documentation

The documentation and API reference is automatically generated by
`ocamldoc` from the interfaces. It can be consulted [online][1]
and there is a generated version in the `doc` directory of the 
distribution. 

[1]: http://erratique.ch/software/xmlm/doc/Xmlm

## Sample programs

A test program, `xmltrip`, is provided in the `test` directory. It can
be built with :

    ocamlbuild test/xmltrip.native

`xmltrip` reads XML files with Xmlm and outputs them back in various
ways. It is useful to understand how Xmlm handles documents. `xmltrip
-help` has more information.

If you need to parse XHTML, the file [`xhtml.ml`](test/xhtml.ml) in
the `test` directory has an OCaml list coupling each XHTML character
entity with its corresponding UTF-8 encoded character string. You can
use it to program a suitable entity callback.
