#!/bin/sh -e

TAGS=principal,annot,bin_annot,short_paths,thread,strict_sequence
J_FLAG=2

BASE_PKG="sexplib"
LWT_PKG=lwt.unix
LWT_SSL_PKG=lwt.ssl
SYNTAX_PKG="camlp4.macro sexplib.syntax"
ASYNC_PKG=async
ASYNC_SSL_PKG=async_ssl

# The Async backend is only supported in OCaml 4.01.0+
OCAML_VERSION=`ocamlc -version`
case $OCAML_VERSION in
4.00.*|3.*)
  echo Async backend only supported in OCaml 4.01.0 or higher
  ;;
*)
HAVE_ASYNC=`ocamlfind query async 2>/dev/null || true`
HAVE_ASYNC_SSL=`ocamlfind query async_ssl 2>/dev/null || true`
echo Async SSL requires a stub-generation version due to
echo a linking order bug. This release has it temporarily disabled.
HAVE_ASYNC_SSL=
;;
esac

HAVE_LWT=`ocamlfind query lwt 2>/dev/null || true`
HAVE_LWT_SSL=`ocamlfind query lwt.ssl 2>/dev/null || true`

add_target () {
  TARGETS="$TARGETS lib/$1.cmxs lib/$1.cma lib/$1.cmxa"
}

add_pkg () {
  PKG="$PKG $1"
}

add_pkg "$SYNTAX_PKG"
add_pkg "$BASE_PKG"
add_target "conduit"
rm -f _tags

echo 'true: syntax(camlp4o)' >> _tags

if [ "$HAVE_ASYNC" != "" ]; then
  echo "Building with Async support."
  echo "# This file is autogenerated by build.sh" > lib/conduit-async.mllib
  echo Async_conduit >> lib/conduit-async.mllib
  add_target "conduit-async"
  ASYNC_REQUIRES=async

  if [ "$HAVE_ASYNC_SSL" != "" ]; then
    echo "Building with Async/SSL support."
    echo 'true: define(HAVE_ASYNC_SSL)' >> _tags
    ASYNC_REQUIRES="$ASYNC_REQUIRES async_ssl"
    echo Async_net_ssl >> lib/conduit-async.mllib
  fi
fi

if [ "$HAVE_LWT" != "" ]; then
  echo "Building with Lwt support."
  echo "# This file is autogenerated by build.sh" > lib/conduit-lwt.mllib
  cat lib/conduit-lwt-base.mllib >> lib/conduit-lwt.mllib
  add_target "conduit-lwt"
  LWT_REQUIRES=lwt.unix
  LWT_SYNTAX=lwt.syntax

  if [ "$HAVE_LWT_SSL" != "" ]; then
    echo "Building with Lwt/SSL support."
    echo 'true: define(HAVE_LWT_SSL)' >> _tags
    LWT_REQUIRES="$LWT_REQUIRES lwt.ssl"
    echo Lwt_unix_net_ssl >> lib/conduit-lwt.mllib
  fi
fi

REQS=`echo $PKG $ASYNC_REQUIRES $LWT_REQUIRES $LWT_SYNTAX | tr -s ' '`

ocamlbuild -use-ocamlfind -j ${J_FLAG} -tag ${TAGS} \
  -cflags "-w A-4-33-40-41-42-43-34-44" \
  -pkgs `echo $REQS | tr ' ' ','` \
  ${TARGETS}

sed \
  -e "s/@BASE_REQUIRES@/${BASE_PKG}/g" \
  -e "s/@VERSION@/`cat VERSION`/g" \
  -e "s/@ASYNC_REQUIRES@/${ASYNC_REQUIRES}/g" \
  -e "s/@LWT_REQUIRES@/${LWT_REQUIRES}/g" \
  META.in > META

if [ "$1" = "true" ]; then
  B=_build/lib/
  ocamlfind remove conduit || true
  FILES=`ls -1 $B/*.cmi $B/*.cmt $B/*.cmti $B/*.cmx $B/*.cmxa $B/*.cma $B/*.cmxs $B/*.a 2>/dev/null || true`
  ocamlfind install conduit META $FILES
fi
