open Std_internal

(* Disallows whitespace around the edges in of_string and t_of_sexp, but doesn't check
   when reading from bin_io. *)
module type S = sig
  include Identifiable with type t = private string

  module Stable : sig
    module V1 : sig
      type nonrec t = t with sexp, bin_io, compare

      type nonrec comparator_witness = comparator_witness
      val comparator : (t, comparator_witness) Comparator.comparator
    end
  end
end

include S

(* Customizes the error messages generated by [of_string]/[of_sexp] to include
   [module_name]. *)
module Make (M : sig val module_name : string end) : S
