(*
 * AUTO-GENERATED FILE DO NOT EDIT
 * Generated from xenlight.ml.in and _libxl_types.ml.in
 *)

(*
 * Copyright (C) 2009-2011 Citrix Ltd.
 * Author Vincent Hanquez <vincent.hanquez@eu.citrix.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 only. with the special
 * exception on linking described in file LICENSE.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *)

type ctx
type domid = int
type devid = int

(* @@LIBXL_TYPES@@ *)
(* AUTO-GENERATED FILE DO NOT EDIT *)
(* autogenerated by 
   genwrap.py libxl_types.idl _libxl_types.mli.in _libxl_types.ml.in _libxl_types.inc
 *)

(* libxl_error implementation *)
type error = 
	 | ERROR_NONSPECIFIC
	 | ERROR_VERSION
	 | ERROR_FAIL
	 | ERROR_NI
	 | ERROR_NOMEM
	 | ERROR_INVAL
	 | ERROR_BADFAIL
	 | ERROR_GUEST_TIMEDOUT
	 | ERROR_TIMEDOUT
	 | ERROR_NOPARAVIRT
	 | ERROR_NOT_READY
	 | ERROR_OSEVENT_REG_FAIL
	 | ERROR_BUFFERFULL
	 | ERROR_UNKNOWN_CHILD

let string_of_error = function
	| ERROR_NONSPECIFIC -> "NONSPECIFIC"
	| ERROR_VERSION -> "VERSION"
	| ERROR_FAIL -> "FAIL"
	| ERROR_NI -> "NI"
	| ERROR_NOMEM -> "NOMEM"
	| ERROR_INVAL -> "INVAL"
	| ERROR_BADFAIL -> "BADFAIL"
	| ERROR_GUEST_TIMEDOUT -> "GUEST_TIMEDOUT"
	| ERROR_TIMEDOUT -> "TIMEDOUT"
	| ERROR_NOPARAVIRT -> "NOPARAVIRT"
	| ERROR_NOT_READY -> "NOT_READY"
	| ERROR_OSEVENT_REG_FAIL -> "OSEVENT_REG_FAIL"
	| ERROR_BUFFERFULL -> "BUFFERFULL"
	| ERROR_UNKNOWN_CHILD -> "UNKNOWN_CHILD"

(* libxl_domain_type implementation *)
type domain_type = 
	 | DOMAIN_TYPE_INVALID
	 | DOMAIN_TYPE_HVM
	 | DOMAIN_TYPE_PV

let string_of_domain_type = function
	| DOMAIN_TYPE_INVALID -> "INVALID"
	| DOMAIN_TYPE_HVM -> "HVM"
	| DOMAIN_TYPE_PV -> "PV"

(* libxl_device_model_version implementation *)
type device_model_version = 
	 | DEVICE_MODEL_VERSION_UNKNOWN
	 | DEVICE_MODEL_VERSION_QEMU_XEN_TRADITIONAL
	 | DEVICE_MODEL_VERSION_QEMU_XEN

let string_of_device_model_version = function
	| DEVICE_MODEL_VERSION_UNKNOWN -> "UNKNOWN"
	| DEVICE_MODEL_VERSION_QEMU_XEN_TRADITIONAL -> "QEMU_XEN_TRADITIONAL"
	| DEVICE_MODEL_VERSION_QEMU_XEN -> "QEMU_XEN"

(* libxl_console_type implementation *)
type console_type = 
	 | CONSOLE_TYPE_UNKNOWN
	 | CONSOLE_TYPE_SERIAL
	 | CONSOLE_TYPE_PV

let string_of_console_type = function
	| CONSOLE_TYPE_UNKNOWN -> "UNKNOWN"
	| CONSOLE_TYPE_SERIAL -> "SERIAL"
	| CONSOLE_TYPE_PV -> "PV"

(* libxl_disk_format implementation *)
type disk_format = 
	 | DISK_FORMAT_UNKNOWN
	 | DISK_FORMAT_QCOW
	 | DISK_FORMAT_QCOW2
	 | DISK_FORMAT_VHD
	 | DISK_FORMAT_RAW
	 | DISK_FORMAT_EMPTY

let string_of_disk_format = function
	| DISK_FORMAT_UNKNOWN -> "UNKNOWN"
	| DISK_FORMAT_QCOW -> "QCOW"
	| DISK_FORMAT_QCOW2 -> "QCOW2"
	| DISK_FORMAT_VHD -> "VHD"
	| DISK_FORMAT_RAW -> "RAW"
	| DISK_FORMAT_EMPTY -> "EMPTY"

(* libxl_disk_backend implementation *)
type disk_backend = 
	 | DISK_BACKEND_UNKNOWN
	 | DISK_BACKEND_PHY
	 | DISK_BACKEND_TAP
	 | DISK_BACKEND_QDISK

let string_of_disk_backend = function
	| DISK_BACKEND_UNKNOWN -> "UNKNOWN"
	| DISK_BACKEND_PHY -> "PHY"
	| DISK_BACKEND_TAP -> "TAP"
	| DISK_BACKEND_QDISK -> "QDISK"

(* libxl_nic_type implementation *)
type nic_type = 
	 | NIC_TYPE_UNKNOWN
	 | NIC_TYPE_VIF_IOEMU
	 | NIC_TYPE_VIF

let string_of_nic_type = function
	| NIC_TYPE_UNKNOWN -> "UNKNOWN"
	| NIC_TYPE_VIF_IOEMU -> "VIF_IOEMU"
	| NIC_TYPE_VIF -> "VIF"

(* libxl_action_on_shutdown implementation *)
type action_on_shutdown = 
	 | ACTION_ON_SHUTDOWN_DESTROY
	 | ACTION_ON_SHUTDOWN_RESTART
	 | ACTION_ON_SHUTDOWN_RESTART_RENAME
	 | ACTION_ON_SHUTDOWN_PRESERVE
	 | ACTION_ON_SHUTDOWN_COREDUMP_DESTROY
	 | ACTION_ON_SHUTDOWN_COREDUMP_RESTART

let string_of_action_on_shutdown = function
	| ACTION_ON_SHUTDOWN_DESTROY -> "DESTROY"
	| ACTION_ON_SHUTDOWN_RESTART -> "RESTART"
	| ACTION_ON_SHUTDOWN_RESTART_RENAME -> "RESTART_RENAME"
	| ACTION_ON_SHUTDOWN_PRESERVE -> "PRESERVE"
	| ACTION_ON_SHUTDOWN_COREDUMP_DESTROY -> "COREDUMP_DESTROY"
	| ACTION_ON_SHUTDOWN_COREDUMP_RESTART -> "COREDUMP_RESTART"

(* libxl_trigger implementation *)
type trigger = 
	 | TRIGGER_UNKNOWN
	 | TRIGGER_POWER
	 | TRIGGER_SLEEP
	 | TRIGGER_NMI
	 | TRIGGER_INIT
	 | TRIGGER_RESET
	 | TRIGGER_S3RESUME

let string_of_trigger = function
	| TRIGGER_UNKNOWN -> "UNKNOWN"
	| TRIGGER_POWER -> "POWER"
	| TRIGGER_SLEEP -> "SLEEP"
	| TRIGGER_NMI -> "NMI"
	| TRIGGER_INIT -> "INIT"
	| TRIGGER_RESET -> "RESET"
	| TRIGGER_S3RESUME -> "S3RESUME"

(* libxl_tsc_mode implementation *)
type tsc_mode = 
	 | TSC_MODE_DEFAULT
	 | TSC_MODE_ALWAYS_EMULATE
	 | TSC_MODE_NATIVE
	 | TSC_MODE_NATIVE_PARAVIRT

let string_of_tsc_mode = function
	| TSC_MODE_DEFAULT -> "DEFAULT"
	| TSC_MODE_ALWAYS_EMULATE -> "ALWAYS_EMULATE"
	| TSC_MODE_NATIVE -> "NATIVE"
	| TSC_MODE_NATIVE_PARAVIRT -> "NATIVE_PARAVIRT"

(* libxl_timer_mode implementation *)
type timer_mode = 
	 | TIMER_MODE_UNKNOWN
	 | TIMER_MODE_DELAY_FOR_MISSED_TICKS
	 | TIMER_MODE_NO_DELAY_FOR_MISSED_TICKS
	 | TIMER_MODE_NO_MISSED_TICKS_PENDING
	 | TIMER_MODE_ONE_MISSED_TICK_PENDING

let string_of_timer_mode = function
	| TIMER_MODE_UNKNOWN -> "UNKNOWN"
	| TIMER_MODE_DELAY_FOR_MISSED_TICKS -> "DELAY_FOR_MISSED_TICKS"
	| TIMER_MODE_NO_DELAY_FOR_MISSED_TICKS -> "NO_DELAY_FOR_MISSED_TICKS"
	| TIMER_MODE_NO_MISSED_TICKS_PENDING -> "NO_MISSED_TICKS_PENDING"
	| TIMER_MODE_ONE_MISSED_TICK_PENDING -> "ONE_MISSED_TICK_PENDING"

(* libxl_bios_type implementation *)
type bios_type = 
	 | BIOS_TYPE_UNKNOWN
	 | BIOS_TYPE_ROMBIOS
	 | BIOS_TYPE_SEABIOS
	 | BIOS_TYPE_OVMF

let string_of_bios_type = function
	| BIOS_TYPE_UNKNOWN -> "UNKNOWN"
	| BIOS_TYPE_ROMBIOS -> "ROMBIOS"
	| BIOS_TYPE_SEABIOS -> "SEABIOS"
	| BIOS_TYPE_OVMF -> "OVMF"

(* libxl_scheduler implementation *)
type scheduler = 
	 | SCHEDULER_UNKNOWN
	 | SCHEDULER_SEDF
	 | SCHEDULER_CREDIT
	 | SCHEDULER_CREDIT2
	 | SCHEDULER_ARINC653

let string_of_scheduler = function
	| SCHEDULER_UNKNOWN -> "UNKNOWN"
	| SCHEDULER_SEDF -> "SEDF"
	| SCHEDULER_CREDIT -> "CREDIT"
	| SCHEDULER_CREDIT2 -> "CREDIT2"
	| SCHEDULER_ARINC653 -> "ARINC653"

(* libxl_shutdown_reason implementation *)
type shutdown_reason = 
	 | SHUTDOWN_REASON_UNKNOWN
	 | SHUTDOWN_REASON_POWEROFF
	 | SHUTDOWN_REASON_REBOOT
	 | SHUTDOWN_REASON_SUSPEND
	 | SHUTDOWN_REASON_CRASH
	 | SHUTDOWN_REASON_WATCHDOG

let string_of_shutdown_reason = function
	| SHUTDOWN_REASON_UNKNOWN -> "UNKNOWN"
	| SHUTDOWN_REASON_POWEROFF -> "POWEROFF"
	| SHUTDOWN_REASON_REBOOT -> "REBOOT"
	| SHUTDOWN_REASON_SUSPEND -> "SUSPEND"
	| SHUTDOWN_REASON_CRASH -> "CRASH"
	| SHUTDOWN_REASON_WATCHDOG -> "WATCHDOG"

(* libxl_vga_interface_type implementation *)
type vga_interface_type = 
	 | VGA_INTERFACE_TYPE_CIRRUS
	 | VGA_INTERFACE_TYPE_STD

let string_of_vga_interface_type = function
	| VGA_INTERFACE_TYPE_CIRRUS -> "CIRRUS"
	| VGA_INTERFACE_TYPE_STD -> "STD"

(* libxl_vendor_device implementation *)
type vendor_device = 
	 | VENDOR_DEVICE_NONE
	 | VENDOR_DEVICE_XENSERVER

let string_of_vendor_device = function
	| VENDOR_DEVICE_NONE -> "NONE"
	| VENDOR_DEVICE_XENSERVER -> "XENSERVER"

(* libxl_ioport_range implementation *)
module Ioport_range = struct
	type t =
	{
		first : int32;
		number : int32;
	}
	external default : ctx -> unit -> t = "stub_libxl_ioport_range_init"
end

(* libxl_iomem_range implementation *)
module Iomem_range = struct
	type t =
	{
		start : int64;
		number : int64;
	}
	external default : ctx -> unit -> t = "stub_libxl_iomem_range_init"
end

(* libxl_vga_interface_info implementation *)
module Vga_interface_info = struct
	type t =
	{
		kind : vga_interface_type;
	}
	external default : ctx -> unit -> t = "stub_libxl_vga_interface_info_init"
end

(* libxl_vnc_info implementation *)
module Vnc_info = struct
	type t =
	{
		enable : bool option;
		listen : string option;
		passwd : string option;
		display : int;
		findunused : bool option;
	}
	external default : ctx -> unit -> t = "stub_libxl_vnc_info_init"
end

(* libxl_spice_info implementation *)
module Spice_info = struct
	type t =
	{
		enable : bool option;
		port : int;
		tls_port : int;
		host : string option;
		disable_ticketing : bool option;
		passwd : string option;
		agent_mouse : bool option;
		vdagent : bool option;
		clipboard_sharing : bool option;
		usbredirection : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_spice_info_init"
end

(* libxl_sdl_info implementation *)
module Sdl_info = struct
	type t =
	{
		enable : bool option;
		opengl : bool option;
		display : string option;
		xauthority : string option;
	}
	external default : ctx -> unit -> t = "stub_libxl_sdl_info_init"
end

(* libxl_dominfo implementation *)
module Dominfo = struct
	type t =
	{
		uuid : int array;
		domid : domid;
		ssidref : int32;
		running : bool;
		blocked : bool;
		paused : bool;
		shutdown : bool;
		dying : bool;
		shutdown_reason : shutdown_reason;
		outstanding_memkb : int64;
		current_memkb : int64;
		shared_memkb : int64;
		paged_memkb : int64;
		max_memkb : int64;
		cpu_time : int64;
		vcpu_max_id : int32;
		vcpu_online : int32;
		cpupool : int32;
		domain_type : domain_type;
	}
	external default : ctx -> unit -> t = "stub_libxl_dominfo_init"
	external list : ctx -> t list = "stub_xl_dominfo_list"
	external get : ctx -> domid -> t = "stub_xl_dominfo_get"
end

(* libxl_vminfo implementation *)
module Vminfo = struct
	type t =
	{
		uuid : int array;
		domid : domid;
	}
	external default : ctx -> unit -> t = "stub_libxl_vminfo_init"
end

(* libxl_version_info implementation *)
module Version_info = struct
	type t =
	{
		xen_version_major : int;
		xen_version_minor : int;
		xen_version_extra : string option;
		compiler : string option;
		compile_by : string option;
		compile_domain : string option;
		compile_date : string option;
		capabilities : string option;
		changeset : string option;
		virt_start : int64;
		pagesize : int;
		commandline : string option;
	}
	external default : ctx -> unit -> t = "stub_libxl_version_info_init"
end

(* libxl_domain_create_info implementation *)
module Domain_create_info = struct
	type t =
	{
		xl_type : domain_type;
		hap : bool option;
		oos : bool option;
		ssidref : int32;
		name : string option;
		uuid : int array;
		xsdata : (string * string) list;
		platformdata : (string * string) list;
		poolid : int32;
		run_hotplug_scripts : bool option;
		pvh : bool option;
		driver_domain : bool option;
	}
	external default : ctx -> unit -> t = "stub_libxl_domain_create_info_init"
end

(* libxl_domain_restore_params implementation *)
module Domain_restore_params = struct
	type t =
	{
		checkpointed_stream : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_domain_restore_params_init"
end

(* libxl_domain_sched_params implementation *)
module Domain_sched_params = struct
	type t =
	{
		sched : scheduler;
		weight : int;
		cap : int;
		period : int;
		slice : int;
		latency : int;
		extratime : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_domain_sched_params_init"
	external get : ctx -> domid -> t = "stub_xl_domain_sched_params_get"
	external set : ctx -> domid -> t -> unit = "stub_xl_domain_sched_params_set"
end

(* libxl_domain_build_info implementation *)
module Domain_build_info = struct

	type type_hvm =
	{
			firmware : string option;
			bios : bios_type;
			pae : bool option;
			apic : bool option;
			acpi : bool option;
			acpi_s3 : bool option;
			acpi_s4 : bool option;
			nx : bool option;
			viridian : bool option;
			timeoffset : string option;
			hpet : bool option;
			vpt_align : bool option;
			timer_mode : timer_mode;
			nested_hvm : bool option;
			smbios_firmware : string option;
			acpi_firmware : string option;
			nographic : bool option;
			vga : Vga_interface_info.t;
			vnc : Vnc_info.t;
			keymap : string option;
			sdl : Sdl_info.t;
			spice : Spice_info.t;
			gfx_passthru : bool option;
			serial : string option;
			boot : string option;
			usb : bool option;
			usbversion : int;
			usbdevice : string option;
			soundhw : string option;
			xen_platform_pci : bool option;
			usbdevice_list : string list;
			vendor_device : vendor_device;
	}
	
	type type_pv =
	{
			kernel : string option;
			slack_memkb : int64;
			bootloader : string option;
			bootloader_args : string list;
			cmdline : string option;
			ramdisk : string option;
			features : string option;
			e820_host : bool option;
	}
	
	type type__union = Hvm of type_hvm | Pv of type_pv | Invalid
	
	type t =
	{
		max_vcpus : int;
		avail_vcpus : bool array;
		cpumap : bool array;
		nodemap : bool array;
		numa_placement : bool option;
		tsc_mode : tsc_mode;
		max_memkb : int64;
		target_memkb : int64;
		video_memkb : int64;
		shadow_memkb : int64;
		rtc_timeoffset : int32;
		exec_ssidref : int32;
		localtime : bool option;
		disable_migrate : bool option;
		cpuid : unit;
		blkdev_start : string option;
		device_model_version : device_model_version;
		device_model_stubdomain : bool option;
		device_model : string option;
		device_model_ssidref : int32;
		extra : string list;
		extra_pv : string list;
		extra_hvm : string list;
		sched_params : Domain_sched_params.t;
		ioports : Ioport_range.t array;
		irqs : int32 array;
		iomem : Iomem_range.t array;
		claim_mode : bool option;
		event_channels : int32;
		xl_type : type__union;
	}
	external default : ctx -> ?xl_type:domain_type -> unit -> t = "stub_libxl_domain_build_info_init"
end

(* libxl_device_vfb implementation *)
module Device_vfb = struct
	type t =
	{
		backend_domid : domid;
		backend_domname : string option;
		devid : devid;
		vnc : Vnc_info.t;
		sdl : Sdl_info.t;
		keymap : string option;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_vfb_init"
	external add : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vfb_add"
	external remove : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vfb_remove"
	external destroy : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vfb_destroy"
end

(* libxl_device_vkb implementation *)
module Device_vkb = struct
	type t =
	{
		backend_domid : domid;
		backend_domname : string option;
		devid : devid;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_vkb_init"
	external add : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vkb_add"
	external remove : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vkb_remove"
	external destroy : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_vkb_destroy"
end

(* libxl_device_disk implementation *)
module Device_disk = struct
	type t =
	{
		backend_domid : domid;
		backend_domname : string option;
		pdev_path : string option;
		vdev : string option;
		backend : disk_backend;
		format : disk_format;
		script : string option;
		removable : int;
		readwrite : int;
		is_cdrom : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_disk_init"
	external add : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_disk_add"
	external remove : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_disk_remove"
	external destroy : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_disk_destroy"
	external list : ctx -> domid -> t list = "stub_xl_device_disk_list"
	external insert : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_disk_insert"
	external of_vdev : ctx -> domid -> string -> t = "stub_xl_device_disk_of_vdev"
end

(* libxl_device_nic implementation *)
module Device_nic = struct
	type t =
	{
		backend_domid : domid;
		backend_domname : string option;
		devid : devid;
		mtu : int;
		model : string option;
		mac : int array;
		ip : string option;
		bridge : string option;
		ifname : string option;
		script : string option;
		nictype : nic_type;
		rate_bytes_per_interval : int64;
		rate_interval_usecs : int32;
		gatewaydev : string option;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_nic_init"
	external add : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_nic_add"
	external remove : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_nic_remove"
	external destroy : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_nic_destroy"
	external list : ctx -> domid -> t list = "stub_xl_device_nic_list"
	external of_devid : ctx -> domid -> int -> t = "stub_xl_device_nic_of_devid"
end

(* libxl_device_pci implementation *)
module Device_pci = struct
	type t =
	{
		func : int;
		dev : int;
		bus : int;
		domain : int;
		vdevfn : int32;
		vfunc_mask : int32;
		msitranslate : bool;
		power_mgmt : bool;
		permissive : bool;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_pci_init"
	external add : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_pci_add"
	external remove : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_pci_remove"
	external destroy : ctx -> t -> domid -> ?async:'a -> unit -> unit = "stub_xl_device_pci_destroy"
	external list : ctx -> domid -> t list = "stub_xl_device_pci_list"
	external assignable_add : ctx -> t -> bool -> unit = "stub_xl_device_pci_assignable_add"
	external assignable_remove : ctx -> t -> bool -> unit = "stub_xl_device_pci_assignable_remove"
	external assignable_list : ctx -> t list = "stub_xl_device_pci_assignable_list"
end

(* libxl_device_vtpm implementation *)
module Device_vtpm = struct
	type t =
	{
		backend_domid : domid;
		backend_domname : string option;
		devid : devid;
		uuid : int array;
	}
	external default : ctx -> unit -> t = "stub_libxl_device_vtpm_init"
end

(* libxl_domain_config implementation *)
module Domain_config = struct
	type t =
	{
		c_info : Domain_create_info.t;
		b_info : Domain_build_info.t;
		disks : Device_disk.t array;
		nics : Device_nic.t array;
		pcidevs : Device_pci.t array;
		vfbs : Device_vfb.t array;
		vkbs : Device_vkb.t array;
		vtpms : Device_vtpm.t array;
		on_poweroff : action_on_shutdown;
		on_reboot : action_on_shutdown;
		on_watchdog : action_on_shutdown;
		on_crash : action_on_shutdown;
	}
	external default : ctx -> unit -> t = "stub_libxl_domain_config_init"
end

(* libxl_diskinfo implementation *)
module Diskinfo = struct
	type t =
	{
		backend : string option;
		backend_id : int32;
		frontend : string option;
		frontend_id : int32;
		devid : devid;
		state : int;
		evtch : int;
		rref : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_diskinfo_init"
end

(* libxl_nicinfo implementation *)
module Nicinfo = struct
	type t =
	{
		backend : string option;
		backend_id : int32;
		frontend : string option;
		frontend_id : int32;
		devid : devid;
		state : int;
		evtch : int;
		rref_tx : int;
		rref_rx : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_nicinfo_init"
end

(* libxl_vtpminfo implementation *)
module Vtpminfo = struct
	type t =
	{
		backend : string option;
		backend_id : int32;
		frontend : string option;
		frontend_id : int32;
		devid : devid;
		state : int;
		evtch : int;
		rref : int;
		uuid : int array;
	}
	external default : ctx -> unit -> t = "stub_libxl_vtpminfo_init"
end

(* libxl_physinfo implementation *)
module Physinfo = struct
	type t =
	{
		threads_per_core : int32;
		cores_per_socket : int32;
		max_cpu_id : int32;
		nr_cpus : int32;
		cpu_khz : int32;
		total_pages : int64;
		free_pages : int64;
		scrub_pages : int64;
		outstanding_pages : int64;
		sharing_freed_pages : int64;
		sharing_used_frames : int64;
		nr_nodes : int32;
		hw_cap : int32 array;
		cap_hvm : bool;
		cap_hvm_directio : bool;
	}
	external default : ctx -> unit -> t = "stub_libxl_physinfo_init"
	external get : ctx -> t = "stub_xl_physinfo_get"
end

(* libxl_numainfo implementation *)
module Numainfo = struct
	type t =
	{
		size : int64;
		free : int64;
		dists : int32 array;
	}
	external default : ctx -> unit -> t = "stub_libxl_numainfo_init"
end

(* libxl_cputopology implementation *)
module Cputopology = struct
	type t =
	{
		core : int32;
		socket : int32;
		node : int32;
	}
	external default : ctx -> unit -> t = "stub_libxl_cputopology_init"
	external get : ctx -> t array = "stub_xl_cputopology_get"
end

(* libxl_sched_credit_params implementation *)
module Sched_credit_params = struct
	type t =
	{
		tslice_ms : int;
		ratelimit_us : int;
	}
	external default : ctx -> unit -> t = "stub_libxl_sched_credit_params_init"
end

(* libxl_domain_remus_info implementation *)
module Domain_remus_info = struct
	type t =
	{
		interval : int;
		blackhole : bool;
		compression : bool;
	}
	external default : ctx -> unit -> t = "stub_libxl_domain_remus_info_init"
end

(* libxl_event_type implementation *)
type event_type = 
	 | EVENT_TYPE_DOMAIN_SHUTDOWN
	 | EVENT_TYPE_DOMAIN_DEATH
	 | EVENT_TYPE_DISK_EJECT
	 | EVENT_TYPE_OPERATION_COMPLETE
	 | EVENT_TYPE_DOMAIN_CREATE_CONSOLE_AVAILABLE

let string_of_event_type = function
	| EVENT_TYPE_DOMAIN_SHUTDOWN -> "DOMAIN_SHUTDOWN"
	| EVENT_TYPE_DOMAIN_DEATH -> "DOMAIN_DEATH"
	| EVENT_TYPE_DISK_EJECT -> "DISK_EJECT"
	| EVENT_TYPE_OPERATION_COMPLETE -> "OPERATION_COMPLETE"
	| EVENT_TYPE_DOMAIN_CREATE_CONSOLE_AVAILABLE -> "DOMAIN_CREATE_CONSOLE_AVAILABLE"

(* libxl_event implementation *)
module Event = struct

	type type_domain_shutdown =
	{
			shutdown_reason : int;
	}
	
	type type_disk_eject =
	{
			vdev : string option;
			disk : Device_disk.t;
	}
	
	type type_operation_complete =
	{
			rc : int;
	}
	
	type type__union = Domain_shutdown of type_domain_shutdown | Domain_death | Disk_eject of type_disk_eject | Operation_complete of type_operation_complete | Domain_create_console_available
	
	type t =
	{
		domid : domid;
		domuuid : int array;
		for_user : int64;
		xl_type : type__union;
	}
	external default : ctx -> ?xl_type:event_type -> unit -> t = "stub_libxl_event_init"
end

(* END OF AUTO-GENERATED CODE *)

exception Error of (error * string)

external ctx_alloc: Xentoollog.handle -> ctx = "stub_libxl_ctx_alloc"

external test_raise_exception: unit -> unit = "stub_raise_exception"

type event =
	| POLLIN (* There is data to read *)
	| POLLPRI (* There is urgent data to read *)
	| POLLOUT (* Writing now will not block *)
	| POLLERR (* Error condition (revents only) *)
	| POLLHUP (* Device has been disconnected (revents only) *)
	| POLLNVAL (* Invalid request: fd not open (revents only). *)

module Domain = struct
	external create_new : ctx -> Domain_config.t -> ?async:'a -> unit -> domid = "stub_libxl_domain_create_new"
	external create_restore : ctx -> Domain_config.t -> (Unix.file_descr * Domain_restore_params.t) ->
		?async:'a -> unit -> domid = "stub_libxl_domain_create_restore"
	external shutdown : ctx -> domid -> unit = "stub_libxl_domain_shutdown"
	external reboot : ctx -> domid -> unit = "stub_libxl_domain_reboot"
	external destroy : ctx -> domid -> ?async:'a -> unit -> unit = "stub_libxl_domain_destroy"
	external suspend : ctx -> domid -> Unix.file_descr -> ?async:'a -> unit -> unit = "stub_libxl_domain_suspend"
	external pause : ctx -> domid -> unit = "stub_libxl_domain_pause"
	external unpause : ctx -> domid -> unit = "stub_libxl_domain_unpause"

	external send_trigger : ctx -> domid -> trigger -> int -> unit = "stub_xl_send_trigger"
	external send_sysrq : ctx -> domid -> char -> unit = "stub_xl_send_sysrq"
end

module Host = struct
	type console_reader
	exception End_of_file

	external xen_console_read_start : ctx -> int -> console_reader  = "stub_libxl_xen_console_read_start"
	external xen_console_read_line : ctx -> console_reader -> string = "stub_libxl_xen_console_read_line"
	external xen_console_read_finish : ctx -> console_reader -> unit = "stub_libxl_xen_console_read_finish"

	external send_debug_keys : ctx -> string -> unit = "stub_xl_send_debug_keys"
end

module Async = struct
	type for_libxl
	type event_hooks
	type osevent_hooks

	external osevent_register_hooks' : ctx -> 'a -> osevent_hooks = "stub_libxl_osevent_register_hooks"
	external osevent_occurred_fd : ctx -> for_libxl -> Unix.file_descr -> event list -> event list -> unit = "stub_libxl_osevent_occurred_fd"
	external osevent_occurred_timeout : ctx -> for_libxl -> unit = "stub_libxl_osevent_occurred_timeout"

	let osevent_register_hooks ctx ~user ~fd_register ~fd_modify ~fd_deregister ~timeout_register ~timeout_fire_now =
		Callback.register "libxl_fd_register" fd_register;
		Callback.register "libxl_fd_modify" fd_modify;
		Callback.register "libxl_fd_deregister" fd_deregister;
		Callback.register "libxl_timeout_register" timeout_register;
		Callback.register "libxl_timeout_fire_now" timeout_fire_now;
		osevent_register_hooks' ctx user

	let async_register_callback ~async_callback =
		Callback.register "libxl_async_callback" async_callback

	external evenable_domain_death : ctx -> domid -> int -> unit = "stub_libxl_evenable_domain_death"
	external event_register_callbacks' : ctx -> 'a -> event_hooks = "stub_libxl_event_register_callbacks"

	let event_register_callbacks ctx ~user ~event_occurs_callback ~event_disaster_callback =
		Callback.register "libxl_event_occurs_callback" event_occurs_callback;
		Callback.register "libxl_event_disaster_callback" event_disaster_callback;
		event_register_callbacks' ctx user
end

let register_exceptions () =
	Callback.register_exception "Xenlight.Error" (Error(ERROR_FAIL, ""));
	Callback.register_exception "Xenlight.Host.End_of_file" (Host.End_of_file)

