#!/usr/bin/env ruby
# Copyright (c) 2008-2009 Citrix Systems Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# This is not a shipped file.  It generates the file named in outputFilename from
# the resx errors file

outputFilename = "XSConsoleLangErrors.py"

if ARGV.size != 1:
  puts "usage: #{$0} <filename>"
  puts "Please supply the filename for xenadmin.hg/XenAdmin/XenAPI/autogen-enterprise/FriendlyErrorNames.resx"
  abort
end

header = [
"# coding: UTF-8",
"# Copyright (c) 2008-2009 Citrix Systems Inc.",
"#",
"# This program is free software; you can redistribute it and/or modify",
"# it under the terms of the GNU General Public License as published by",
"# the Free Software Foundation; version 2 only.",
"#",
"# This program is distributed in the hope that it will be useful,",
"# but WITHOUT ANY WARRANTY; without even the implied warranty of",
"# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
"# GNU General Public License for more details.",
"#",
"# You should have received a copy of the GNU General Public License along",
"# with this program; if not, write to the Free Software Foundation, Inc.,",
"# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.",
"#",
"# Generated by #{File.basename($0)} #{Time.now}",
"# from #{File.basename(ARGV[0])} last modified #{File.mtime(ARGV[0])}",
"",
"class LangErrors:",
"  @classmethod",
"  def Translate(cls, inTag):",
"    return cls.errorMap.get(inTag, inTag)",
"",
"  errorMap = {"
]

footer = [
"  }"
]

errorMap = {}

File.open(ARGV[0]) do |file|
  name = nil
  file.each_line do |line|
    if name
      if line =~ /<value>([^<]+?)\.?<\/value>/ # Also removes trailing full stop
        errorMap[name] = $1.gsub("'") { "\\\'" } # Replace ' with \'
      end
      name = nil
    else
      if line =~ /<data name="([^"]+)" xml:space="preserve">/
        name=$1
      end
    end
  end
end

File.open(outputFilename, 'w') do |file|
  header.each { |line| file.write("#{line}\n") }
  errorMap.sort.each { |key, value| file.write("    '#{key}' : '#{value}',\n") }
  footer.each { |line| file.write("#{line}\n") }
end
