/*
 * e820.h: support functions for manipulating the e820 table
 *
 * Copyright (c) 2006-2007, Intel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the Intel Corporation nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __E820_H__
#define __E820_H__

#ifndef E820_RAM
#define E820_RAM            1
#endif

#ifndef E820_RESERVED
#define E820_RESERVED       2
#endif

#ifndef E820_ACPI
#define E820_ACPI           3
#endif

#ifndef E820_NVS
#define E820_NVS            4
#endif

#ifndef E820_UNUSABLE
#define E820_UNUSABLE       5
#endif

/* these are only used by e820_check_region() */
#define E820_MIXED          ((uint32_t)-1 - 1)
#define E820_GAP            ((uint32_t)-1)

#ifndef __XEN__
extern bool copy_e820_map(multiboot_info_t *mbi);
extern bool e820_protect_region(uint64_t addr, uint64_t size, uint32_t type);
extern bool e820_reserve_ram(uint64_t base, uint64_t length);
extern void print_e820_map(void);
extern void replace_e820_map(multiboot_info_t *mbi);
extern uint32_t e820_check_region(uint64_t base, uint64_t length);
extern uint64_t get_max_ram(multiboot_info_t *mbi);
#endif    /* __XEN__ */

#endif    /* __E820_H__ */


/*
 * Local variables:
 * mode: C
 * c-set-style: "BSD"
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: nil
 * End:
 */
